/*
	DevSaver Web Framework
	Copyright (c) 2013-2018 DevSaver. 
	All rights reserved.
		web:  www.devsaver.com
		mail: support@devsaver.com				
*/

var STBFooter = Object.create(STBModule.prototype);

STBFooter.name = "Footer";

STBFooter.updatePosition = function() {

    try {
        var body			= $('body'),
            main			= $("main"),
            footerHeight	= $("footer").height(),
            winHeight		= window.innerHeight,
            wrapperHeight	= $(".wrapper").height(),
            headerHeight	= wrapperHeight;

		if (body.attr("data-menu-over-title") == "true") {
			headerHeight = 0;
		} 

        main.css("min-height", "auto");

        if ((main.height() + headerHeight + footerHeight) < winHeight) {
            main.css("min-height", (winHeight - headerHeight - footerHeight));
        }

    } catch (e) {
        getStack(0, e);
    }
}

STBFooter.collapseFooter = function(val) {
	$('body').attr('data-footer-collapse' , val == true ? "true" : "false");

	$("footer .widget-head .title").css("height" , "auto"); 
}

STBFooter.collapseClick = function() {
	if ($('body').attr('data-footer-collapse') == 'true') {

		var parseTitle = function () {
			var widgetF = $(this).parent().parent(),
				widgetFHeight = widgetF.outerHeight(),
				widgetHead = widgetF.find('.widget-head'),
				widgetHeadHeight = widgetHead.outerHeight();

			widgetF.animate({height: widgetHeadHeight} , 500);

			$(this).on('click', function () {

				var $this = $(this),
					$parent = $(this).closest(".widget");

				if(!$this.hasClass("closed")) {
					$parent.animate({height: widgetFHeight} , 500);
					$this.addClass("closed");
				} else {
					$parent.animate({height: widgetHeadHeight} , 500);
					$this.removeClass("closed");
				}

				$parent.toggleClass('toggle-widget');

				if ($parent.hasClass("toggle-widget")) {

					if ($parent.find(".isotope-container").length > 0) {
						$parent.find(".isotope-container").isotope('layout');
					}
				}
			});
		};

		$('.widget-head', 'footer').find('.title').each(parseTitle);
	}		
}


STBFooter.runOnReady = function() {
	STBFooter.collapseClick();
}

STBFooter.runOnResize = function() {

	if (!site.onepage) {
		STBFooter.updatePosition();
	}
}

STBFooter.runOnLoad = function() {
	if (!site.onepage) {
		STBFooter.updatePosition();
	}
}

site.registerModule(STBFooter);